const RetryError = require('../error/RetryError');

module.exports = function() {
    return function(logger, response, body) {
        var logType = 'retryCondition';

        if ([200, 404, 500].indexOf(response.statusCode) === -1) {
            logger
                .info()
                .type(logType)
                .write('Expected response status 200 or 404, got %s', response.statusCode);
            return new RetryError('Server response status was neither 200 OK nor 404', body);
        }
    };
};
