const plog = require('plog');
const Error = require('../error/common');

class AntifraudApi {
    constructor(lodId, dao) {
        this._dao = dao;
        this._logger = new plog(lodId, 'api', 'antifraud');
    }

    score({extId, uid, ip, cardId, phone, loginId, yandexUid, paymentType, serviceId, retpath}) {
        return this._dao.call('post', '/scoring', {
            t: new Date().getTime(),
            external_id: extId,
            channel: 'challenge',
            sub_channel: 'family',
            uid,
            ip,
            retpath,
            card_id: cardId,
            user_phone: phone,
            login_id: loginId,
            yandex_uid: yandexUid,
            service_id: serviceId,
            payment_type: paymentType
        });
    }

    save({extId, status}) {
        return this._dao.call('post', '/save', {
            t: new Date().getTime(),
            external_id: extId,
            status,
            channel: 'challenge',
            sub_channel: 'family'
        });
    }
}

AntifraudApi.ApiError = Error;

module.exports = AntifraudApi;
