const PLog = require('plog');
const assert = require('assert');
const fs = require('fs');
const pdaoHttp = require('../../pdao/Http');
const Error = require('../error');

class AvatarsApi {
    constructor(lodId, dao) {
        assert(dao instanceof pdaoHttp, 'Data access object should be an instance of Http DAO');

        this._dao = dao;
        this._logger = new PLog(lodId, 'api', 'avatars');
    }

    put({namespace, file}) {
        return this._dao.call('post', `/put-${namespace}/`, {
            file: file && file.size && file.path ? fs.createReadStream(file.path) : undefined
        });
    }
}

AvatarsApi.ApiError = class extends Error {
    constructor(errors, response) {
        /* eslint-disable no-this-before-super */
        this.name = 'ApiError';
        this.message = 'Api errors encountered: ' + JSON.stringify(errors);
        this._errors = errors;

        super(response);
    }

    /**
     * Whether the given code was among the errors
     * @param {string} code
     * @returns {boolean}
     */
    contains(code) {
        return this._errors.indexOf(code) > -1;
    }

    forEveryCode(callback) {
        this._errors.forEach(callback);
    }
};

module.exports = AvatarsApi;
