const RetryError = require('../error/RetryError');

// eslint-disable-next-line consistent-return
module.exports = () => (logger, response, body) => {
    const logType = 'retryCondition';

    if (![200, 404, 400, 401, 500].includes(response.statusCode)) {
        logger
            .info()
            .type(logType)
            .write('Expected response status 200 or 404, got %s', response.statusCode);
        return new RetryError('Server response status was neither 200 OK nor 404', body);
    }
};
