const plog = require('plog');
const Error = require('../error');

class BnplApi {
    constructor(lodId, dao) {
        this._dao = dao;
        this._logger = new plog(lodId, 'api', 'bnpl');
    }

    getUserStat() {
        return this._dao.call('get', '/passport/user/stat', {});
    }
}

BnplApi.ApiError = class extends Error {
    /* eslint-disable no-this-before-super */
    constructor(errors, response) {
        this.name = 'ApiError';
        this.message = 'Api errors encountered: ' + JSON.stringify(errors);
        this._errors = errors;

        super(response);
    }

    contains(code) {
        return this._errors.indexOf(code) > -1;
    }

    forEveryCode(callback) {
        this._errors.forEach(callback);
    }
};

module.exports = BnplApi;
