var assert = require('assert');
var inherit = require('inherit');
var pdaoHttp = require('pdao/Http');
var PLog = require('plog');
var ApiError = require('../error');

module.exports = inherit(
    {
        __constructor: function(lodId, dao) {
            assert(dao instanceof pdaoHttp, 'Data access object should be an instance of Http DAO');

            /**
             * @type DAO
             */
            this._dao = dao;

            this._logger = new PLog(lodId, 'api', 'connect');
        },

        getInviteInfo: function(code) {
            assert(typeof code === 'string', 'Code should be a string');
            assert(/^\w{32}$/.test(code), 'Code should be a 32 symbol and alphanumeric');

            return this._dao.call('get', '/invites/' + code + '/', {});
        },

        useInvite: function(code) {
            assert(typeof code === 'string', 'Code should be a string');
            assert(/^\w{32}$/.test(code), 'Code should be a 32 symbol and alphanumeric');

            return this._dao.call('post', '/invites/' + code + '/use/', {});
        }
    },
    {
        /**
         * An error object to represent errors returned by api
         *
         * @class ApiError
         * @extends Error
         */
        ApiError: inherit(ApiError, {
            /**
             * @param {string[]} errors
             * @param {object} response
             * @constructor
             */
            __constructor: function(errors, response) {
                this.name = 'ApiError';
                this.message = 'Api errors encountered: ' + JSON.stringify(errors);
                this._errors = errors;

                this.__base(response);
            },

            /**
             * Whether the given code was among the errors
             * @param {string} code
             * @returns {boolean}
             */
            contains: function(code) {
                return this._errors.indexOf(code) > -1;
            },

            forEveryCode: function(callback) {
                this._errors.forEach(callback);
            }
        })
    }
);
