const PLog = require('plog');
const assert = require('assert');
const pdaoHttp = require('../../pdao/Http');

class DeleteDataApi {
    constructor(lodId, dao) {
        assert(dao instanceof pdaoHttp, 'Data access object should be an instance of Http DAO');

        this._dao = dao;
        this._logger = new PLog(lodId, 'api', 'deleteData');
    }

    getStatus(input) {
        return this._dao.call('get', '/takeout/status/', input);
    }

    deleteItems({id, request_id}) {
        return this._dao.call('post', `/takeout/delete/?request_id=${request_id}`, {id});
    }
}

DeleteDataApi.ApiError = class extends Error {
    constructor(errors, response) {
        super(response);
        this.name = 'ApiError';
        this.message = 'Api errors encountered: ' + JSON.stringify(errors);
        this._errors = errors;
    }
};

module.exports = DeleteDataApi;
