var RetryError = require('../error/RetryError');

module.exports = (logger, response, body) => {
    if (![200, 404, 400].includes(response.statusCode)) {
        logger
            .info()
            .type('retryCondition')
            .write('Expected response status 200 or 404, got %s', response.statusCode);

        return new RetryError('Server response status was neither 200 OK nor 404', body);
    }
};
