module.exports = require('inherit')(
    {
        __constructor: function(lodId, dao) {
            require('assert')(
                dao instanceof require('pdao/Http'),
                'Data access object should be an instance of Http DAO'
            );

            /**
             * @type DAO
             */
            this._dao = dao;

            this._logger = new (require('plog'))(lodId, 'api', 'disk');
        },

        /**
         * Retrieve the browser syn info
         * IMPORTANT: This disk handle is ipv4-only
         *
         * @param {String} uid
         * @returns {Promise}
         */
        browserSyncEnabled: function(uid) {
            //TODO: test
            require('assert')(uid && typeof uid === 'string', 'UID should be a string');

            var that = this;

            return this._dao.call('get', '/user_sync_versions/' + uid, {}).then(function(response) {
                var syncOn = Boolean(response);

                that._logger.info('Sync is %s', syncOn ? 'on' : 'off');
                return syncOn;
            });
        }
    },
    {
        /**
         * An error object to represent errors returned by api
         *
         * @class ApiError
         * @extends Error
         */
        ApiError: require('inherit')(require('../error'), {
            /**
             * @param {string[]} errors
             * @param {object} response
             * @constructor
             */
            __constructor: function(errors, response) {
                this.name = 'ApiError';
                this.message = 'Api errors encountered: ' + JSON.stringify(errors);
                this._errors = errors;

                this.__base(response);
            },

            /**
             * Whether the given code was among the errors
             * @param {string} code
             * @returns {boolean}
             */
            contains: function(code) {
                return this._errors.indexOf(code) > -1;
            },

            forEveryCode: function(callback) {
                this._errors.forEach(callback);
            }
        })
    }
);
