const protobuf = require('protobufjs');
const schemas = require('@yandex-int/maps-proto-schemas').get(['atom', 'common2', 'direct', 'search']);
const Response = protobuf.loadSync(schemas).lookup('yandex.maps.proto.common2.response.Response');

module.exports = require('inherit')(
    {
        __constructor: function(lodId, dao) {
            require('assert')(
                dao instanceof require('pdao/Http'),
                'Data access object should be an instance of Http DAO'
            );

            /**
             * @type DAO
             */
            this._dao = dao;

            this._logger = new (require('plog'))(lodId, 'api', 'geo');
        },

        getLocation: function(data) {
            return this._dao.call('get', '/yandsearch', data).then(function(response) {
                return Response.decode(response).toJSON();
            });
        }
    },
    {
        /**
         * An error object to represent errors returned by api
         *
         * @class ApiError
         * @extends Error
         */
        ApiError: require('inherit')(require('../error'), {
            /**
             * @param {string[]} errors
             * @param {object} response
             * @constructor
             */
            __constructor: function(errors, response) {
                this.name = 'ApiError';
                this.message = 'Api errors encountered: ' + JSON.stringify(errors);
                this._errors = errors;

                this.__base(response);
            },

            /**
             * Whether the given code was among the errors
             * @param {string} code
             * @returns {boolean}
             */
            contains: function(code) {
                return this._errors.indexOf(code) > -1;
            },

            forEveryCode: function(callback) {
                this._errors.forEach(callback);
            }
        })
    }
);
