const assert = require('assert');
const PdaoHttp = require('pdao/Http');
const plog = require('plog');
const Error = require('../error');

class IotApi {
    constructor(lodId, dao) {
        assert(dao instanceof PdaoHttp, 'Data access object should be an instance of Http DAO');
        this._dao = dao;
        this._logger = new plog(lodId, 'api', 'iot');
    }

    _makeRequest(method, url, params = {}) {
        return this._dao.call(method, url, params);
    }

    getUserInfo() {
        return this._makeRequest('get', '/v1.0/user/info');
    }
}

IotApi.ApiError = class extends Error {
    /* eslint-disable no-this-before-super */
    constructor(errors, response) {
        this.name = 'ApiError';
        this.message = 'Api errors encountered: ' + JSON.stringify(errors);
        this._errors = errors;

        super(response);
    }

    contains(code) {
        return this._errors.indexOf(code) > -1;
    }

    forEveryCode(callback) {
        this._errors.forEach(callback);
    }
};

module.exports = IotApi;
