module.exports = require('inherit')({
    __constructor: function(definition) {
        var _ = require('lodash');
        var assert = require('assert');

        assert(_.isObjectLike(definition), 'Auth Log Entry definition should be a plain object');
        this._checkDefinition(definition);
        this._entry = definition;
    },

    _checkDefinition: function() {
        throw new Error('Should be overwritten by a child class');
    },

    _checkIp: function(ipDefinition) {
        require('assert')(require('lodash').isPlainObject(ipDefinition), 'IP definition should be a plain object');
        require('assert')(
            ipDefinition.value && typeof ipDefinition.value === 'string',
            'IP address should be a string'
        );
        require('assert')(!ipDefinition.AS || typeof ipDefinition.AS === 'number', 'AS should be a number');
        require('assert')(!ipDefinition.geoid || typeof ipDefinition.geoid === 'number', 'GeoID should be a number');
    },

    _checkAuthtype: function(authtype) {
        require('assert')(!authtype || typeof authtype === 'string', 'Authtype should be a string');
    },

    _checkTimestamp: function(timestamp) {
        require('assert')(timestamp && typeof timestamp === 'number', 'Timestamp should be a number');
    },

    getIp: function() {
        return this._entry.ip.value;
    },

    getTimestamp: function() {
        return new Date(this._entry.timestamp * 1000); //Sec to ms
    },

    getAuthtype: function() {
        return this._entry.authtype.toUpperCase();
    }
});
