module.exports = require('inherit')(require('./Abstract'), {
    _checkDefinition: function(definition) {
        this._checkIp(definition.ip);
        this._checkAuthtype(definition.authtype);
        this._checkTimestamp(definition.timestamp);

        require('assert')(require('lodash').isPlainObject(definition.oauth), 'Oauth block should be a plain object');
        require('assert')(
            definition.oauth.token_id && typeof definition.oauth.token_id === 'string',
            'Token ID should be a string'
        );
        require('assert')(
            definition.oauth.client_id && typeof definition.oauth.client_id === 'string',
            'Client ID should be a string'
        );
        require('assert')(
            definition.oauth.scopes && typeof definition.oauth.scopes === 'string',
            'Scopes definition should be a string'
        );

        require('assert')(
            !definition.oauth.device_id || typeof definition.oauth.device_id === 'string',
            'Device id should be a string if defined'
        );
        require('assert')(
            !definition.oauth.device_name || typeof definition.oauth.device_name === 'string',
            'Device name should be a string if defined'
        );
    },

    getTokenId: function() {
        return this._entry.oauth.token_id;
    }
});
