module.exports = function(definition) {
    var logger = new (require('plog'))(null, 'AuthLogEntry', 'factory');

    logger.verbose('Searching for a suitable model for %j', definition);

    var _ = require('lodash');

    require('assert')(_.isObjectLike(definition), 'Auth Log Entry definition should be a plain object');

    if (_.isObjectLike(definition.oauth)) {
        if (definition.oauth.AP) {
            logger.debug('Application password');
            return new (require('./AppPass'))(definition);
        }

        logger.debug('Oauth token');
        return new (require('./OauthToken'))(definition);
    }

    if (_.isObjectLike(definition.browser) || _.isObjectLike(definition.os)) {
        logger.debug('Web password');
        return new (require('./WebPass'))(definition);
    }

    logger.debug('Application via web password');
    return new (require('./WebApp'))(definition);
};
