module.exports = require('inherit')({
    __constructor: function(token) {
        var _ = require('lodash');
        var assert = require('assert');

        assert(_.isObjectLike(token), 'Token definition should be a plain object');

        assert(token.id && typeof token.id === 'number', 'ID should be a number');
        assert(typeof token.is_app_password === 'boolean', 'App password flag should be a boolean');

        assert(token.scopes instanceof require('./ScopesCollection'), 'Scopes should be a ScopesCollection');
        assert(token.client instanceof require('./Client'), 'Client should be an instance of ClientModel');

        ['create_time', 'issue_time'].forEach(function(field) {
            assert(token[field] && typeof token[field] === 'number', field + ' should be a string');
        });

        ['device_id', 'device_name'].forEach(function(field) {
            assert(
                token[field] === null || (token[field] && typeof token[field] === 'string'),
                field + ' should be null or a string'
            );
        });

        this._token = token;
        this._alias = null;
    },

    getId: function() {
        return this._token.id;
    },

    isAppPassword: function() {
        return this._token.is_app_password;
    },

    getClient: function() {
        return this._token.client;
    },

    getClientSlug: function() {
        return require('../../OAuth').getAppPasswordsSlugByClientId(this.getClient().getId());
    },

    getDeviceId: function() {
        return this._token.device_id;
    },

    getDeviceName: function() {
        return this._token.device_name;
    },

    getIssueTime: function() {
        return new Date((this._token.issue_time || 0) * 1000) || null;
    },

    getScopes: function() {
        return this._token.scopes;
    },

    setAlias: function(alias) {
        require('assert')(alias && typeof alias === 'string', 'Token alias should be a string');
        this._alias = alias;
    },

    getAlias: function() {
        return this._alias;
    }
});
