var RetryError = require('../error/RetryError');

module.exports = function(retryCodes) {
    require('assert')(
        Array.isArray(retryCodes) &&
            retryCodes.every(function(code) {
                return typeof code === 'string';
            }),
        'RetryCodes should be an array of strings'
    );

    return function(logger, response, body) {
        var logType = 'retryCondition';

        if (response.statusCode !== 200) {
            logger
                .info()
                .type(logType)
                .write('Expected response status 200, got %s', response.statusCode);
            return new RetryError('Server response status was not 200 OK', body);
        }

        var _ = require('lodash');

        if (body.status === 'error' && _.isArray(body.errors)) {
            var retryCode = _.find(body.errors, function(error) {
                return _.includes(retryCodes, error);
            });

            if (retryCode) {
                logger
                    .info()
                    .type(logType)
                    .write('Error code %s was found in response %j', retryCode, body);
                return new RetryError('Api returned an error code from retryCodes list', body);
            }
        }
    };
};
