const PLog = require('plog');
const assert = require('assert');
const inherit = require('inherit');
const pdaoHttp = require('../../pdao/Http');
const error = require('../error');

module.exports = inherit(
    {
        __constructor(lodId, dao) {
            assert(dao instanceof pdaoHttp, 'Data access object should be an instance of Http DAO');

            this._dao = dao;
            this._logger = new PLog(lodId, 'api', 'plusLanding');
        },

        yandexBalance() {
            return this._dao.call('get', '/yandex-balance', {}).then((response) => {
                return response;
            });
        }
    },
    {
        /**
         * An error object to represent errors returned by api
         *
         * @class ApiError
         * @extends Error
         */
        ApiError: inherit(error, {
            /**
             * @param {string[]} errors
             * @param {object} response
             * @constructor
             */
            __constructor(errors, response) {
                this.name = 'ApiError';
                this.message = 'Api errors encountered: ' + JSON.stringify(errors);
                this._errors = errors;

                this.__base(response);
            },

            /**
             * Whether the given code was among the errors
             * @param {string} code
             * @returns {boolean}
             */
            contains(code) {
                return this._errors.indexOf(code) > -1;
            },

            forEveryCode(callback) {
                this._errors.forEach(callback);
            }
        })
    }
);
