const PLog = require('plog');
const assert = require('assert');
const pdaoHttp = require('../../pdao/Http');
const {formatSubscriptions} = require('./utils');

class PraktikumApi {
    constructor(lodId, dao) {
        assert(dao instanceof pdaoHttp, 'Data access object should be an instance of Http DAO');

        this._dao = dao;
        this._logger = new PLog(lodId, 'api', 'praktikum');
    }

    getSubscriptions({uid, language}) {
        return this._dao
            .call('get', '/internal/passport-info/user/', {
                // debug uid
                // uid: 4028416956,
                uid,
                language
            })
            .then((response) => {
                const {result = {}, error} = response;
                const {subscriptions = []} = result;

                return {
                    status: error ? 'error' : 'success',
                    intervals: formatSubscriptions(subscriptions)
                };
            })
            .catch((error) => ({
                status: 'error',
                error
            }));
    }
}

PraktikumApi.ApiError = class extends Error {
    constructor(errors, response) {
        super(response);
        this.name = 'ApiError';
        this.message = 'Api errors encountered: ' + JSON.stringify(errors);
        this._errors = errors;
    }

    /**
     * Whether the given code was among the errors
     * @param {string} code
     * @returns {boolean}
     */
    contains(code) {
        return this._errors.indexOf(code) > -1;
    }

    forEveryCode(callback) {
        this._errors.forEach(callback);
    }
};

module.exports = PraktikumApi;
