const getStatus = (interval = {}) => {
    if (interval.active) {
        return 'active';
    }

    if (interval.grace) {
        return 'in-grace';
    }

    return 'stopped';
};

const formatSubscriptions = (subscriptions) =>
    subscriptions.map((subscription) => {
        const {paidProducts: [interval = {}] = [], ...rest} = subscription;
        const {nextPaymentDate, nextPaymentAmount = {}} = interval;
        const {currency, amount} = nextPaymentAmount;

        return {
            ...rest,
            type: 'praktikum',
            status: getStatus(interval),
            nextPayment: nextPaymentDate,
            productInfo: {price: {currency: currency || 'RUB', amount}}
        };
    });

module.exports = {formatSubscriptions};
