const plog = require('plog');
const Error = require('../error');

class TrustPaymentsApi {
    constructor(lodId, dao) {
        this._dao = dao;
        this._logger = new plog(lodId, 'api', 'trust-payments');
    }

    getPaymentsMethods() {
        return this._dao.call('get', '/v2/payment_methods', {});
    }

    getRefunds({purchaseToken, amount, reason = ''} = {}) {
        return this._dao.call('post', '/v2/payments/refunds/', {
            purchase_token: purchaseToken,
            orders: [{delta_amount: amount}],
            reason_desc: reason
        });
    }

    startRefunds({refundId = ''} = {}) {
        return this._dao.call('post', `/v2/payments/refunds/${refundId}/start/`, {});
    }
}

TrustPaymentsApi.ApiError = class extends Error {
    /* eslint-disable no-this-before-super */
    constructor(errors, response) {
        this.name = 'ApiError';
        this.message = 'Api errors encountered: ' + JSON.stringify(errors);
        this._errors = errors;

        super(response);
    }

    contains(code) {
        return this._errors.indexOf(code) > -1;
    }

    forEveryCode(callback) {
        this._errors.forEach(callback);
    }
};

module.exports = TrustPaymentsApi;
