module.exports = require('inherit')(require('./index'), {
    /**
     * @param {string} message
     * @param {object} response
     * @constructor
     */
    __constructor: function(message, response, errCode) {
        this.name = 'RetryError';
        this.message = message;
        this.errCode = errCode;

        this.__base(response);
    },

    getErrCode: function() {
        return this.errCode;
    },

    toString: function() {
        var string = require('util').format('%s: %s', this.name, this.message);

        if (this.getErrCode()) {
            string += ' due to ' + this.getErrCode();
        }
        return string;
    }
});
