const Error = require('./index');

module.exports = class CommonApiError extends Error {
    /* eslint-disable no-this-before-super */
    constructor(errors, response) {
        this.name = 'ApiError';
        this.message = 'Api errors encountered: ' + JSON.stringify(errors);
        this._errors = errors;

        super(response);
    }

    contains(code) {
        return this._errors.indexOf(code) > -1;
    }

    forEveryCode(callback) {
        this._errors.forEach(callback);
    }
};
