/**
 * An error object to represent errors returned by api
 *
 * @class ApiError
 * @extends Error
 */
var ApiError = require('inherit')(Error, {
    name: null,
    message: null,

    /**
     * @param {object} response
     * @constructor
     */
    __constructor: function(response) {
        require('assert')(this.name && typeof this.name === 'string', 'Name should be defined for the error');
        require('assert')(this.message && typeof this.message === 'string', 'Message should be defined for the error');

        this._response = response;
        Error.captureStackTrace(this, ApiError);
    },

    getResponse: function() {
        return this._response;
    }
});

module.exports = ApiError;
