var fs = require('fs');
var LogEntry = require('plog/logger/Entry');
var Formatter = require('./formatter/TSKVFormatter');
var Handler = require('./handler/FileHandler');
var Configurator = require('plog/logger/Configurator');
var configurator = new Configurator();

var Logger = require('inherit')(require('plog/logger/Logger'), {
    __constructor: function() {
        var args = Array.prototype.slice.call(arguments);
        var stream = args.shift();

        this._formatter = new Formatter(configurator);
        this._handler = new Handler(stream, configurator);
        this.__base.apply(this, args);
    },
    log: function() {
        var entry = new LogEntry(this._formatter, this._handler);
        var args = Array.prototype.slice.call(arguments);

        if (this.getLogId()) {
            entry.logId(this.getLogId());
        }

        if (args.length > 0) {
            args.unshift('%j');
            entry.level('info').write.apply(entry, args);
        }

        return entry;
    }
});

module.exports = function(filePath) {
    var stream = fs.createWriteStream(filePath, {flags: 'a', encoding: 'utf8'});

    stream.on('error', function(err) {
        throw new Error(err);
    });

    return require('inherit')(Logger, {
        __constructor: function() {
            var args = Array.prototype.slice.call(arguments);

            args.unshift(stream);
            this.__base.apply(this, args);
        }
    });
};
