var util = require('util');
var assert = require('assert');
var _ = require('lodash');

module.exports = require('inherit')(
    require('../../../../node_modules/plog/logger/formatter/AbstractFormatter.js'),
    {
        _format: function(entry) {
            var converted = this.__self.convertToTSKV(JSON.parse(entry.getMessage()));
            var requestId = entry.getLogId();

            return util.format('tskv\trequest_id=%s\t%s\n', requestId, converted);
        }
    },
    {
        getDates: function(date) {
            date = date || new Date();
            var splitted = date.toString().split(' ');
            var day = splitted[2];
            var month = splitted[1];
            var year = date.getFullYear();
            var time = splitted[4];

            return {
                unixtime: (date.getTime() / 1000).toFixed(), // unixtime in seconds
                timestamp: util.format('%s/%s/%s:%s', day, month, year, time) // 08/Jun/2015:14:10:01
            };
        },
        convertToTSKV: function(obj) {
            assert(_.isObjectLike(obj), 'Message should be plain object');
            return _.map(obj, function(val, key) {
                return key + '=' + val;
            }).join('\t');
        }
    }
);
