(function() {
    passport.mixins = {
        /**
         * Intercept child events with parent's method of same name
         *
         * @param {Block} parent        Parent block, who will be intercepting events
         * @param {Block} child         Child block, whose events will be intercepted
         * @param {string[]} events     Events to intercept
         */
        interceptEvents: function(parent, child, events) {
            var emit = child.emit;

            //Intercept emit calls for the communication events
            child.emit = function(eventName) {
                if (events.indexOf(eventName) > -1) {
                    parent[eventName].apply(parent, Array.prototype.slice.call(arguments, 1));
                } else {
                    emit.apply(child, arguments);
                }
            }.bind(child);
        },

        nanoislandizeInputs: function(params) {
            var mixinParams = params || {};
            var runNbMethod = function(nbctrl, method, params) {
                if (nbctrl && typeof nbctrl[method] === 'function') {
                    nbctrl[method](params);
                }
            };

            var control = passport.block('control');

            //Initing nanoblocks inside the control when it is created
            var originalConstruct = control.construct;

            control.construct = function() {
                originalConstruct.apply(this, arguments);

                var nanoelement = this.$(this.controlSelector || '[data-nb]').get(0);

                if (nanoelement) {
                    this.nbctrl = nb.block(nanoelement);
                }

                if (this.isOriginInput) {
                    return;
                }

                //It is expected that control has data-serialized on it's root element
                //And that data-serialized contains the JSON.stringify(Field.compile())
                var errors = (this.$el.data('serialized') || {}).error;

                if (
                    Array.isArray(errors) &&
                    errors.some(function(err) {
                        return err.active;
                    })
                ) {
                    runNbMethod(this.nbctrl, 'showError');
                }
            };

            //Val to work with nanoislands
            var originalVal = control.val;

            control.val = function() {
                if (!this.nbctrl) {
                    return originalVal.apply(this, arguments);
                }

                if (this.nbctrl.getType() === 'select') {
                    return this.nbctrl.value;
                }

                if (this.nbctrl.getType() !== 'input') {
                    return;
                }

                if (arguments.length === 0) {
                    return this.nbctrl.getValue();
                } else {
                    this.nbctrl.setValue.apply(this.nbctrl, arguments);
                }
            };

            /*
             Error handling to work with nanoislands

             It is expected, that errors are passed to input via
             nb-input({
                 error: {
                    content: //All the errors to be selected with control.error
                 }
             }
             */
            var originalError = control.error;

            control.error = function(code) {
                originalError.apply(this, arguments);

                if (code) {
                    var params = {};

                    if (this.nbctrl && mixinParams.appendErrorToControl) {
                        params.appendTo = this.nbctrl.$node.parent().get(0);
                    }
                    if ($.isPlainObject(this.nbErrorParams)) {
                        params = $.extend(params, this.nbErrorParams);
                    }

                    runNbMethod(this.nbctrl, 'showError', params);
                } else {
                    runNbMethod(this.nbctrl, 'hideError');
                }
            };

            var originSearch = control.$;

            control.$ = function(selector) {
                var $result = originSearch.apply(this, arguments);

                if ($result.length) {
                    return $result;
                }

                if (this.nbctrl && this.nbctrl.error) {
                    return this.nbctrl.error.$node.find(selector);
                }

                return $([]);
            };
        }
    };

    passport.defineMixin = function(name, mixin) {
        passport.mixins[name] = function(block) {
            if (mixin.events) {
                block.events = block.events || {};
                $.extend(block.events, mixin.events);
            }

            $.extend(block, mixin, {events: block.events});
        };
    };

    passport.defineMixin('validateOnFocusout', {
        events: {
            focusout: 'onFocusout'
        },

        onFocusout: function() {
            this.checkUpdate();
        }
    });

    passport.defineMixin('nameValidations', {
        validate: function(silent) {
            var validated = new $.Deferred();

            if (!this.inited.already) {
                validated.reject();
                return validated;
            }

            if (this.isEmpty()) {
                this.validationResult(false, 'missingvalue', silent);
            } else if (passport.util.normalize(this.val()).length > 50) {
                // 50 characters is what gets stored
                this.validationResult(false, 'toolong', silent);
            } else {
                this.validationResult(true, null, silent);
            }

            validated.resolve();
            return validated;
        }
    });

    passport.defineMixin('clickNextButtonOnEnterInsideInput', {
        events: {
            'keypress .p-control__input': '_explicitClickNextButton'
        },

        _explicitClickNextButton: function(event) {
            if (passport.util.getKeyCode(event) === 13) {
                //Enter was clicked
                var nextButton = $(event.target).next('button');

                if (!nextButton.length) {
                    nextButton = this.$el.find('button');
                }

                if (nextButton.length) {
                    nextButton.click();
                    event.preventDefault();
                }
            }
        }
    });
})();
