(function() {
    var SUPPRESS_ERROR = true;
    var cssSpecialCharsRegex = /[^_a-zA-Z0-9-]*/g;

    passport.validator = {
        /**
         * Watch list
         *
         * @type Object
         */
        store: {},

        /**
         * Adds controls to watch list
         * @param {passport.control} control
         */
        register: function(control) {
            this.store[control.id] = true;

            // Revalidations on updates
            $(document).on(
                'validation.' + control.id,
                function(event, isValid) {
                    this.store[control.id] = isValid;
                }.bind(this)
            );

            control.validate(SUPPRESS_ERROR);
        },

        /**
         * Checks whether all controls are valid
         *
         * @param {Passport.Block} [control]  Control to check validation state
         * @returns {Boolean}
         */
        check: function(control) {
            if (control) {
                return this.store[control.id];
            }

            for (var key in this.store) {
                if (this.store.hasOwnProperty(key) && this.store[key] === false) {
                    return false;
                }
            }

            return true;
        },

        /**
         * Gets error code from server validation response
         * @param {Object} response
         * @returns {String|Array}
         */
        getErrorCode: function(response) {
            if (Array.isArray(response)) {
                var result = [];
                var that = this;

                response.forEach(function(response) {
                    result.push(that.getErrorCode(response));
                });

                return result;
            }

            if (response === String(response)) {
                return response.replace(cssSpecialCharsRegex, '');
            }

            return response.code.replace(cssSpecialCharsRegex, '');
        },

        /**
         * Gets error code from server validation response (NEW SHEME)
         * @param {Array} response
         * @returns {String|Array}
         */
        getErrorCodeFromEntity: function(response) {
            var result = [];
            var that = this;

            [].concat(response).forEach(function(error) {
                var _error = error.split('.');

                _error.shift();

                result.push(that.getErrorCode(_error.join('.')));
            });

            return result;
        }
    };
})();
