import React from 'react';
import {compose} from '@bem-react/core';
import {withRegistry, Registry} from '@bem-react/di';
import {cnAttach, Attach as AttachDesktop, withSizeM, withSizeL} from '@yandex-lego/components/Attach/desktop';
import {Button} from '../Button';
import {withWidthMax} from './size/width-max';

const attachRegistry = new Registry({id: cnAttach()});

attachRegistry.set('Button', Button);

// Композиция из различных модификаторов
const AttachCompose = compose(withSizeM, withSizeL, withWidthMax, withRegistry(attachRegistry))(AttachDesktop);

const Attach = (props) => <AttachCompose {...props} />;

export {Attach};
