import './Button.styl';
import React from 'react';
import PropTypes from 'prop-types';
import {compose} from '@bem-react/core';
import {
    Button as ButtonDesktop,
    withSizeL,
    withSizeM,
    withSizeS,
    withViewAction,
    withViewDefault,
    withViewPseudo,
    withViewClear,
    withWidthMax,
    withTypeLink,
    withTypeSubmit
} from '@yandex-lego/components/Button/desktop';
import {withSizeFamilyL, withSizeFamilyM} from './size/family';
import {withSizeXM} from './size/xm';
import {withSizeXXL} from './size/xxl';
import {withSizeSubscription} from './size/subscription';
import {withSizeSmartTvXL, withSizeSmartTvL} from './size/smarttv';
import {withViewAuthSmartTV} from './view/auth-smart-tv';
import {withViewOauthAuthorize} from './view/oauth-authorize';
import {withViewWhite} from './view/white';
import {withViewPlus} from './view/plus';
import {withViewToloka} from './view/custom/toloka';
import {withViewCustomsDark} from './view/custom/customsDark';
import {withViewTransparent} from './view/transparent';
import {withViewCustomsYgogoRider} from './view/custom/customsYgogoRider';
import {withViewCustomsTurlaRider} from './view/custom/customsTurlaRider';
import {withViewRoundedShadow} from './view/rounded-shadow';

const LegoButton = compose(
    withSizeS,
    withSizeM,
    withSizeXM,
    withSizeL,
    withSizeXXL,
    withSizeFamilyL,
    withSizeFamilyM,
    withSizeSubscription,
    withSizeSmartTvXL,
    withSizeSmartTvL,
    withViewAction,
    withViewDefault,
    withViewPseudo,
    withViewClear,
    withViewAuthSmartTV,
    withViewOauthAuthorize,
    withViewWhite,
    withViewPlus,
    withWidthMax,
    withTypeLink,
    withTypeSubmit,
    withViewToloka,
    withViewCustomsDark,
    withViewTransparent,
    withViewCustomsYgogoRider,
    withViewCustomsTurlaRider,
    withViewRoundedShadow
)(ButtonDesktop);
const availableViews = [
    'default',
    'pseudo',
    'action',
    'clear',
    'white',
    'auth-smart-tv',
    'plus',
    'toloka',
    'customsDark',
    'oauth-authorize',
    'transparent',
    'customsYgogoRider',
    'customsTurlaRider',
    'rounded-shadow'
];

const Button = ({type = 'button', view = 'action', text, onClick, size, children, dataT, ...props}) => (
    <LegoButton
        onClick={onClick}
        type={type}
        view={availableViews.includes(view) ? view : 'action'}
        size={size}
        data-t={dataT ? `button:${view}:${dataT}` : `button:${view}`}
        {...props}
    >
        {children || text}
    </LegoButton>
);

Button.propTypes = {
    view: PropTypes.oneOf(availableViews),
    size: PropTypes.oneOf(['s', 'm', 'xm', 'l', 'xxl', 'family-m', 'family-l', 'subscription', 'smarttv-l', 'smarttv-xl']),
    width: PropTypes.oneOf(['max', 'auto']),
    type: PropTypes.string,
    text: PropTypes.string,
    url: PropTypes.string,
    id: PropTypes.string,
    target: PropTypes.string,
    onClick: PropTypes.func,
    disabled: PropTypes.bool,
    progress: PropTypes.bool,
    icon: PropTypes.object,
    children: PropTypes.node,
    dataT: PropTypes.string
};

export {Button};
