import './Checkbox.styl';
import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {compose} from '@bem-react/core';
import {
    Checkbox as CheckboxDesktop,
    withSizeS,
    withSizeM,
    withViewDefault
} from '@yandex-lego/components/Checkbox/desktop';
import {withViewYellow} from './view/yellow';
import {withSizeL} from './size/size-l';

const b = cn('Checkbox');

// Композиция из различных модификаторов
const CheckboxCompose = compose(withSizeS, withSizeM, withSizeL, withViewDefault, withViewYellow)(CheckboxDesktop);

export const Checkbox = ({size = 'm', view = 'default', dangerouslyLabel, id, dataT, ...props}) => (
    <>
        <CheckboxCompose view={view} size={size} data-t={dataT ? `checkbox:${dataT}` : 'checkbox'} id={id} {...props} />
        {dangerouslyLabel && (
            <label className={b('label', {size})} htmlFor={id} dangerouslySetInnerHTML={{__html: dangerouslyLabel}} />
        )}
    </>
);

Checkbox.propTypes = {
    size: PropTypes.oneOf(['s', 'm', 'l']),
    view: PropTypes.string,
    dataT: PropTypes.string,
    id: PropTypes.string,
    dangerouslyLabel: PropTypes.string
};
