import React from 'react';
import PropTypes from 'prop-types';
import {Drawer as LegoDrawer} from '@yandex-lego/components/Drawer/touch-phone/bundle';

const ANIMATION = {
    tension: 500,
    friction: 30
};

export const Drawer = (props) => <LegoDrawer {...props} animation={ANIMATION} />;

Drawer.propTypes = {
    onClose: PropTypes.func,
    nested: PropTypes.bool,
    visible: PropTypes.bool,
    children: PropTypes.node,
    className: PropTypes.string,
    dragDisabled: PropTypes.bool,
    titleComponent: PropTypes.node,
    direction: PropTypes.oneOf(['left', 'right', 'bottom']),
    scope: PropTypes.oneOfType([PropTypes.func, PropTypes.object])
};
