import './Icon.styl';
import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';

const b = cn('PasspIcon');

export const Icon = ({size = 's', type, place, withHover, dataT, fillParent, className}) => (
    <span
        className={b({[type]: true, size, place, withHover, fill: fillParent}, [className])}
        data-t={dataT ? `icon:${type}:${dataT}` : `icon:${type}`}
    />
);

Icon.propTypes = {
    className: PropTypes.string,
    size: PropTypes.oneOf(['s', 'm', 'l', 'xl']),
    type: PropTypes.string.isRequired,
    place: PropTypes.oneOf(['button']),
    dataT: PropTypes.string,
    withHover: PropTypes.bool,
    fillParent: PropTypes.bool
};
