// @see https://lego.yandex-team.ru/components/lego/latest/?storybook=%2Fdocs%2Fcontrols-textinput-desktop--playground
import './Input.styl';
import React from 'react';
import PropTypes from 'prop-types';
import {compose} from '@bem-react/core';
import {cn} from '@bem-react/classname';
import {
    Textinput as TextinputDesktop,
    withViewDefault,
    withSizeM,
    withSizeS,
    withHasClear,
    withPinClearRound,
    withPinRoundClear,
    withPinRoundBrick,
    withPinBrickRound,
    withPinClearClear
} from '@yandex-lego/components/Textinput/desktop';
import {withViewOneBorder, withFilled} from './view/one-border';
import {withViewFloatingLabel} from './view/floating-label';
import {withViewThinInput} from './view/thin-input';
import {withBigInput} from './view/big_input';
import {withViewRoundedCorner} from './view/rounded-corner';
import {withSizeL} from './size/size-l';
import {withSizeXL} from './size/size-xl';
import {withSizeXXL} from './size/size-xxl';

// Композиция из различных модификаторов
const TextInput = compose(
    withViewDefault,
    withViewOneBorder,
    withViewFloatingLabel,
    withViewThinInput,
    withBigInput,
    withViewRoundedCorner,
    withFilled,
    withSizeM,
    withSizeS,
    withSizeL,
    withSizeXL,
    withSizeXXL,
    withHasClear,
    withPinClearRound,
    withPinRoundClear,
    withPinRoundBrick,
    withPinBrickRound,
    withPinClearClear
)(TextinputDesktop);

const b = cn('Textinput');

const Input = ({size = 'm', view = 'default', type = 'text', name, dataT, state, hint, description, dir, ...props}) => {
    const hintId = `field:input-${dataT || name}:hint`;
    const descriptionId = `field:input-${dataT || name}:description`;

    return (
        <>
            <TextInput
                size={size}
                view={view}
                type={type}
                name={name}
                data-t={`field:input-${dataT || name}`}
                state={state}
                dir={dir}
                {...props}
            />
            {view === 'big-input' && <div className='Textinput-Line' />}
            {hint && (
                <div
                    id={hintId}
                    role={state === 'error' ? 'alert' : 'status'}
                    aria-live={state === 'error' ? 'assertive' : 'polite'}
                    data-t={hintId}
                    className={b('Hint', {state})}
                    dangerouslySetInnerHTML={{__html: hint}}
                />
            )}
            {description && (
                <div
                    data-t={descriptionId}
                    id={descriptionId}
                    className={b('Hint', {state})}
                    dangerouslySetInnerHTML={{__html: description}}
                />
            )}
        </>
    );
};

Input.propTypes = {
    name: PropTypes.string,
    dataT: PropTypes.string,
    size: PropTypes.oneOf(['s', 'm', 'l', 'xl', 'xxl']),
    type: PropTypes.oneOf(['text', 'password', 'tel', 'number']),
    view: PropTypes.oneOf(['one-border', 'default', 'floating-label', 'big-input', 'thin-input', 'rounded-corner']),
    state: PropTypes.oneOf(['error', 'success']),
    hint: PropTypes.string,
    description: PropTypes.string
};

export {Input};
