import './Link.styl';
import React from 'react';
import PropTypes from 'prop-types';
import {compose} from '@bem-react/core';
import {Link as LinkDesktop, withViewDefault, withPseudo} from '@yandex-lego/components/Link/desktop';
import {withWeightMedium, withWeightBold} from './weight';

// Композиция из различных модификаторов
const LinkCompose = compose(withViewDefault, withWeightMedium, withWeightBold, withPseudo)(LinkDesktop);

export const Link = ({view = 'default', dataT, ...props}) => (
    <LinkCompose view={view} data-t={dataT ? `link:${view}:${dataT}` : `link:${view}`} {...props} />
);

Link.propTypes = {
    target: PropTypes.string,
    view: PropTypes.string,
    href: PropTypes.string,
    dataT: PropTypes.string,
    pseudo: PropTypes.bool,
    weight: PropTypes.oneOf(['normal', 'medium', 'bold'])
};
