// @see https://lego.yandex-team.ru/components/lego/latest/?storybook=%2Fdocs%2Fcontrols-menu-desktop--playground
import React from 'react';
import PropTypes from 'prop-types';
import {compose} from '@bem-react/core';
import {
    Menu as MenuDesktop,
    withSizeS,
    withSizeM,
    withViewDefault,
    withWidthAuto,
    withWidthMax,
    withThemeNormal
} from '@yandex-lego/components/Menu/desktop';
const MenuCompose = compose(
    withSizeS,
    withSizeM,
    withViewDefault,
    withWidthAuto,
    withWidthMax,
    withThemeNormal
)(MenuDesktop);

export const Menu = ({view, dataT, ...props}) => (
    <MenuCompose view={view} theme={view ? '' : 'normal'} data-t={dataT ? `menu:${dataT}` : 'menu'} {...props} />
);

Menu.propTypes = {
    view: PropTypes.oneOf(['default']),
    size: PropTypes.oneOf(['s', 'm']),
    dataT: PropTypes.string
};
