// @see https://lego.yandex-team.ru/components/lego/latest/?storybook=%2Fdocs%2Fsurface-modal-desktop--playground
import './Modal.styl';
import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {compose} from '@bem-react/core';
import {Modal as ModalDesktop, withThemeNormal} from '@yandex-lego/components/Modal/desktop';
import {withZIndex} from '@yandex-lego/components/withZIndex';
import {Icon} from '../IconLego';
import {FamilyModalCloser} from './closer/family';

const b = cn('Modal');

// Композиция из различных модификаторов
const ModalCompose = compose(withThemeNormal, withZIndex)(ModalDesktop);

export const Modal = ({onCloserClick, closerView = 'default', theme = 'normal', children, dataT, ...props}) => (
    <ModalCompose theme={theme} data-t={dataT ? `modal:${dataT}` : 'modal'} {...props}>
        <div className={b('inner')}>
            {Boolean(onCloserClick) && (
                <button
                    className={b('closer', {view: closerView})}
                    onClick={onCloserClick}
                    data-t={dataT ? `modal:closer:${dataT}` : 'modal:closer'}
                >
                    <div className={b('closerIcon')}>
                        {closerView === 'default' && <Icon glyph='type-cross-websearch' />}
                        {closerView === 'family' && <FamilyModalCloser />}
                    </div>
                </button>
            )}
            {children}
        </div>
    </ModalCompose>
);

Modal.propTypes = {
    dataT: PropTypes.string,
    theme: PropTypes.oneOf(['normal']),
    contentVerticalAlign: PropTypes.oneOf(['top', 'middle', 'bottom']),
    onCloserClick: PropTypes.func,
    children: PropTypes.node.isRequired,
    closerView: PropTypes.oneOf(['default', 'round'])
};
