import './RadioButton.styl';
import React from 'react';
import PropTypes from 'prop-types';
import {
    RadioButton as RadioButtonDesktop,
    withViewDefault,
    withSizeM
} from '@yandex-lego/components/RadioButton/desktop';
import {cnRadioButton} from '@yandex-lego/components/RadioButton';
import {compose, withBemMod} from '@bem-react/core';

export const withWidthMax = withBemMod(cnRadioButton(), {
    width: 'max'
});

export const viewRoundedMax = withBemMod(cnRadioButton(), {
    view: 'rounded'
});

export const viewBigRoundedMax = withBemMod(cnRadioButton(), {
    view: 'bigRounded',
});

// Композиция из различных модификаторов
const RadioButtonCompose = compose(
    withViewDefault,
    withSizeM,
    withWidthMax,
    viewRoundedMax,viewBigRoundedMax
)(RadioButtonDesktop);

const RadioButton = ({size = 'm', view = 'default', ...props}) => (
    <RadioButtonCompose size={size} view={view} {...props} />
);

RadioButton.propTypes = {
    size: PropTypes.oneOf(['m']),
    view: PropTypes.oneOf(['default', 'rounded', 'bigRounded']),
    width: PropTypes.oneOf(['max'])
};

export {RadioButton};
