import './Select.styl';
import React from 'react';
import PropTypes from 'prop-types';
import {compose} from '@bem-react/core';
import {withRegistry, Registry} from '@bem-react/di';
import {Select as SelectTouch, cnSelect, withWidthMax} from '@yandex-lego/components/Select/touch-phone';
import {withTogglable} from '@yandex-lego/components/withTogglable';
import {Button} from '../Button';
import {Icon} from '../IconLego';
import {withPinBrickBrick, withPinClearClear} from './pin/pin';

const selectRegistry = new Registry({id: cnSelect()});

selectRegistry.set('Trigger', Button).set('Icon', Icon);

const SelectCompose = compose(
    withTogglable,
    withWidthMax,
    withPinBrickBrick,
    withPinClearClear,
    withRegistry(selectRegistry)
)(SelectTouch);

export const Select = ({view = 'pseudo', dataT, ...props}) => (
    <SelectCompose view={view} data-t={dataT ? `select:${view}:${dataT}` : `select:${view}`} {...props} />
);

Select.propTypes = {
    view: PropTypes.string,
    dataT: PropTypes.string,
    options: PropTypes.arrayOf(
        PropTypes.shape({
            value: PropTypes.string.isRequired,
            content: PropTypes.string.isRequired
        })
    ).isRequired
};
