import React from 'react';
import PropTypes from 'prop-types';
import {compose} from '@bem-react/core';
import {
    Spin as SpinDesktop,
    withSizeXXS,
    withSizeXS,
    withSizeS,
    withSizeM,
    withSizeL,
    withViewDefault,
    withPositionCenter
} from '@yandex-lego/components/Spin/desktop';

// Композиция из различных модификаторов
const SpinCompose = compose(
    withSizeXXS,
    withSizeXS,
    withSizeS,
    withSizeM,
    withSizeL,
    withViewDefault,
    withPositionCenter
)(SpinDesktop);

export const Spin = ({size = 'm', dataT, ...props}) => (
    <SpinCompose view='default' size={size} data-t={dataT ? `spin:${dataT}` : 'spin'} {...props} />
);

Spin.propTypes = {
    size: PropTypes.oneOf(['xxs', 'xs', 's', 'm', 'l']),
    position: PropTypes.oneOf(['center']),
    dataT: PropTypes.string
};
