import React from 'react';
import PropTypes from 'prop-types';
import {compose} from '@bem-react/core';
import {Textarea as TextAreaDesktop, withViewDefault, withSizeM} from '@yandex-lego/components/Textarea/desktop';
import {withSizeL} from './size/size-l';

// Композиция из различных модификаторов
const TextAreaCompose = compose(withViewDefault, withSizeM, withSizeL)(TextAreaDesktop);

export const TextArea = ({size = 'm', dataT, ...props}) => (
    <TextAreaCompose size={size} view='default' data-t={dataT ? `textarea:${dataT}` : 'textarea'} {...props} />
);

TextArea.propTypes = {
    size: PropTypes.oneOf(['m', 'l']),
    dataT: PropTypes.string
};
