import React from 'react';
import PropTypes from 'prop-types';
import {compose} from '@bem-react/core';
import {Tumbler as TumblerDesktop, withSizeM, withViewDefault} from '@yandex-lego/components/Tumbler/desktop';

const TumblerCompose = compose(withSizeM, withViewDefault)(TumblerDesktop);

export const Tumbler = ({size = 'm', dataT, ...props}) => (
    <TumblerCompose view='default' size={size} data-t={dataT ? `tumbler:${dataT}` : 'tumbler'} {...props} />
);

Tumbler.propTypes = {
    size: PropTypes.oneOf(['m']),
    dataT: PropTypes.string
};
