import React from 'react';
import PropTypes from 'prop-types';
import {onRerender} from './utils';
import * as UserHTML from '@yandex-lego/serp-header/dist/base/user2.desktop';
import User2HTML from '@yandex-lego/serp-header/dist/custom-items/user2.desktop';
import {User as UserDesktop} from '@yandex-lego/user/desktop';
import {User as UserTouch} from '@yandex-lego/user/touch';
import './User.styl';

export class User extends React.Component {
    componentDidUpdate() {
        // PASSP-35740
        onRerender();
    }
    shouldComponentUpdate(props) {
        return props.retpath !== this.props.retpath;
    }

    renderNewUserComponent = () => {
        const {
            tld,
            isMobile,
            lang,
            logoutOrigin,
            retpath,
            hasPlus,
            avatarId,
            ci,
            isTesting,
            project = 'passport'
        } = this.props;
        const props = {
            avatarId,
            blackbox: isTesting ? 'test' : 'prod',
            env: isTesting ? 'test' : 'prod',
            project,
            lang,
            plus: hasPlus,
            tld,
            retpath,
            ci,
            logoutOrigin
        };
        const Component = isMobile ? UserTouch : UserDesktop;

        return <Component {...props} />;
    };

    renderOldUserComponent = () => {
        const {tld, lang, customMenuItems, ...props} = this.props;

        const user =
            tld === 'eu'
                ? User2HTML.getContent({tld, lang, ctx: {...props, customMenuItems}})
                : UserHTML.getContent({tld, lang, ctx: props});

        return <div dangerouslySetInnerHTML={{__html: user}} />;
    };

    render() {
        const {isNewUserLegoComponent} = this.props;

        return isNewUserLegoComponent ? this.renderNewUserComponent() : this.renderOldUserComponent();
    }
}

User.propTypes = {
    tld: PropTypes.string.isRequired,
    lang: PropTypes.string.isRequired,
    retpath: PropTypes.string.isRequired,
    ci: PropTypes.string,
    project: PropTypes.string,
    isMobile: PropTypes.bool,
    logoutOrigin: PropTypes.string,
    passportHost: PropTypes.string,
    hasPlus: PropTypes.bool,
    avatarId: PropTypes.string,
    isTesting: PropTypes.bool,
    isNewUserLegoComponent: PropTypes.bool,
    customMenuItems: PropTypes.arrayOf(
        PropTypes.shape({
            text: PropTypes.string.isRequired,
            url: PropTypes.string.isRequired,
            action: PropTypes.string
        })
    )
};
