class AbstractDAOError extends Error {
    constructor(message) {
        super(message);
        this.name = null;
        Error.captureStackTrace(this, AbstractDAOError);
    }
}

class RetryCondition extends AbstractDAOError {
    /**
     * @param {string} message
     * @param {object} response
     * @constructor
     */
    constructor(message, response) {
        super(message);
        this.name = 'RetryCondition';
        this._response = response;
    }

    getResponse() {
        return this._response;
    }
}

class Abstract {
    call() {
        throw new Error('Should be overwritten by a successor');
    }
}

Abstract.Error = AbstractDAOError;
Abstract.RetryCondition = RetryCondition;

module.exports = Abstract;
