module.exports = function(yr) {
    var config = require('./config/config.js');
    var i18n = require('putils').i18n;

    require('yate/lib/runtime.js').externals['_passport-header_i18n'] = i18n;
    require('yate/lib/runtime.js').externals['_passport-header_stringify'] = function(obj) {
        if (obj.length && obj.length > 0) {
            obj = obj[0];
        }

        return JSON.stringify(obj.data);
    };

    if (!i18n.isConfigured()) {
        //i18n may be configured by the parent project
        i18n.setAllowedLangs(['ru', 'en', 'uk', 'tr', 'fr', 'fi']);
    }

    i18n.setKeysets(['Frontend', 'common', 'dropdown', 'Header']) //Make sure needed keysets are in the list
        .loadFromDir(__dirname + '/loc'); //Load the translations

    var nodeset2obj = function(nodeset) {
        if (nodeset.length && nodeset[0]) {
            return nodeset[0].data;
        }

        return null;
    };

    require('./built/header.yate.js'); //File created by make on install

    function getNavigationByTld(tld, isWSUser, isIntranet) {
        var links = config.navigation[tld] || config.navigation['ru'] || {};
        var head = isWSUser ? ['portal', 'mail', 'yamb'] : ['mail'];
        var tail = [];
        var navigation = [];
        var limits = {
            ru: 4,
            com: 2,
            'com.tr': 2,
            ua: 3
        };

        var limit = limits[tld || 'ru'] || limits['ru'];
        var mainNavigation = [];
        var subNavigation = [];

        switch (isIntranet) {
            case true:
                tail = [
                    'calendar',
                    'wiki',
                    'meetingrooms',
                    'st',
                    'contacts',
                    'golem',
                    'staff',
                    'planner',
                    'at',
                    'idm',
                    'lib',
                    'doc',
                    'lego',
                    'mag',
                    'guide',
                    'ml',
                    'otrs',
                    'stat',
                    'jhist'
                ];

                break;

            default:
                switch (tld) {
                    case 'ua':
                        tail = [
                            'calendar',
                            'disk',
                            'images',
                            'news',
                            'maps',
                            'market',
                            'pogoda',
                            'tv',
                            'music',
                            'afisha',
                            'browser',
                            'all'
                        ];

                        break;
                    case 'com.tr':
                        tail = ['disk', 'search', 'images', 'maps', 'browser', 'translate', 'pogoda', 'all'];

                        break;
                    case 'com':
                        tail = ['disk', 'search', 'images', 'maps', 'browser', 'translate'];

                        break;
                    default:
                        tail = ['calendar', 'disk', 'search', 'maps', 'browser', 'translate', 'pogoda', 'news'];

                        if (isWSUser) {
                            tail = [
                                'calendar',
                                'disk',
                                'images',
                                'news',
                                'maps',
                                'market',
                                'pogoda',
                                'tv',
                                'music',
                                'afisha',
                                'browser',
                                'all'
                            ];
                        }
                }
        }

        navigation = getNavigation(head.concat(tail), tld, isIntranet);

        if (navigation.length > 5) {
            mainNavigation = navigation.slice(0, limit);
            subNavigation = navigation.slice(limit);

            mainNavigation.push({
                id: 'more',
                url: links.all
            });
        } else {
            mainNavigation = navigation;
        }

        return {
            mainNavigation: mainNavigation,
            subNavigation: subNavigation
        };
    }

    function getNavigation(items, tld, isIntranet) {
        var links = isIntranet ? config.navigation.intranet : config.navigation[tld] || config.navigation['ru'] || {};
        var navigation = [];

        if (items.length) {
            items.forEach(function(item) {
                navigation.push({
                    id: item,
                    url: links[item]
                });
            });
        }

        return navigation;
    }

    yr.externals['pheader'] = function(data, options) {
        data = nodeset2obj(data);
        options = nodeset2obj(options);

        options.theme = options.theme || 'white';

        var _ = require('lodash');
        var assert = require('assert');

        assert(_.isPlainObject(data), 'Data should be a plain object');
        assert(data.tld && typeof data.tld === 'string', 'tld should be a string TLD code');
        assert(
            typeof data.language === 'string' && data.language.length === 2,
            'Language is a two-letter language code'
        );
        assert(!data.service || typeof data.service === 'string', 'Service title should be a string if defined');
        assert(!data.serviceUrl || typeof data.serviceUrl === 'string', 'Service URL should be a string if defined');
        assert(
            !data.logoutRetpath || typeof data.logoutRetpath === 'string',
            'Logout retpath should be a string if defined'
        );
        assert(options.env && typeof options.env === 'string', 'env should be a string ENVIRONMENT code');
        assert(typeof options.isWSUser === 'boolean', 'isWSUser should be a boolean');
        assert(options.env in config.paths, 'Env should be one of ' + Object.keys(config.paths));
        assert(['white', 'black'].indexOf(options.theme) > -1, 'Theme should be either white or black');

        data.language = data.language.toLowerCase();
        var links = config.navigation[data.tld] || config.navigation['ru'] || {};

        if (data.defaultUser) {
            var avatarPath = '';

            if (data.defaultUser.avatarUrl && config.paths && config.paths[options.env].avatarHeader) {
                avatarPath = config.paths[options.env].avatarHeader.replace('%avatarId%', data.defaultUser.avatarUrl);
                avatarPath += '?rnd=' + String(Math.round(Math.random() * 1000000));
            }

            data.defaultUser = {
                firstletter: data.defaultUser.displayName.charAt(0),
                rest: data.defaultUser.displayName.substr(1),
                avatarUrl: avatarPath
            };
        }

        assert(_.isPlainObject(options), 'Options should be a plain object');

        options.tld = data.tld;
        options.locale = data.language;
        options.paths = config.paths[options.env];

        data.navigation = getNavigationByTld(data.tld, options.isWSUser, options.env === 'intranet');

        if (!data.serviceUrl && data.service) {
            data.serviceUrl = links[data.service];
        }

        if (data.service === 'oauth') {
            options.paths.embeddedauth += '&origin=' + data.origin;
        }

        return require('yate/lib/runtime.js').run('_passport-header', {
            header: data,
            options: options
        });
    };
};
