(function() {
    passport.block('passport-header-authlink', 'block', {
        init: function() {
            var $link = this.$('.js-passport-header-authlink-button');
            var tld = $link.data('tld');
            var env = $link.data('env');
            var service = $link.data('service');
            var origin = $link.data('origin');
            var passportHost;

            switch (env) {
                case 'intranet': {
                    passportHost = 'passport.yandex-team.';
                    break;
                }
                case 'production-team': {
                    passportHost = 'passport.yandex-team.';
                    break;
                }
                case 'rc-team': {
                    passportHost = 'passport-rc.yandex-team.';
                    break;
                }
                case 'testing-team': {
                    passportHost = 'passport-test.yandex-team.';
                    break;
                }
                case 'development':
                case 'testing': {
                    passportHost = 'passport-test.yandex.';
                    break;
                }
                case 'rc': {
                    passportHost = 'passport-rc.yandex.';
                    break;
                }
                default:
                    passportHost = 'passport.yandex.';
            }

            passportHost += tld;

            var url = 'https://' + passportHost + '/auth?retpath=' + encodeURIComponent(window.location.href);

            if (service == 'oauth') {
                url += '&origin=' + origin;
            }

            $link.prop('href', url);
        }
    });
})();
