(function() {
    passport.block('header-navigation', {
        events: {
            'click .js-passport-header-navigation_dropdown_trigger': 'toggleDropdown'
        },

        testElem: function(event) {
            return (
                /passport-header-navigation-item_more/.test(event.target.className) ||
                $(event.target)
                    .parents()
                    .hasClass('passport-header-navigation-item_more')
            );
        },

        toggleDropdown: function(event) {
            event.preventDefault();
            this.$('.js-passport-header-menu__dropdown').toggleClass('passport-header-menu_open');
        },

        hideDropdown: function(event) {
            if (!this.testElem(event)) {
                this.$('.js-passport-header-menu__dropdown').removeClass('passport-header-menu_open');
            }
        },

        bindEvents: function() {
            $(document).on('click', this.hideDropdown.bind(this));
        },

        init: function() {
            this.bindEvents();
        }
    });
})();
