(function() {
    passport.block('user', {
        events: {
            'click .js-passport-header-user_dropdown_trigger': 'toggleDropdown',
            'click .js-passport-header-dropdown-user': 'changeDefault',
            'click .js-passport-header-dropdown-menu__promo_closer': 'hidePromo'
        },

        _avatarHeader: null,
        _avatarDropdown: null,
        _accounts: null,
        _accountsList: [],
        _canAddMore: null,
        _accountsLength: null,
        _currentUid: null,
        _defaultAccount: null,

        getData: function() {
            var self = this;

            $.ajax({
                dataType: 'json',
                url: this._accounts,
                data: {
                    yu: passport.util.getCookie('yandexuid'),
                    lang: self.options.locale || 'ru',
                    uid: typeof window.uid === 'number' ? window.uid : ''
                },
                xhrFields: {
                    withCredentials: true
                },
                crossDomain: true
            }).done(function(data) {
                if (data && data.accounts && data.accounts.length) {
                    var hasValidAccounts = data.accounts.some(function(account) {
                        return account.status === 'VALID';
                    });

                    if (!hasValidAccounts) {
                        self.hideUserInformation();
                        return;
                    }

                    self.parseData(data);

                    self.hideAuthLink();
                    self.showUserInformation();
                } else {
                    self.hideUserInformation();
                }
            });
        },

        setDefaultAccount: function(data) {
            var defaultAccount;
            var validAccounts = data.accounts.filter(function(account) {
                account.status === 'VALID';
            });

            if (data.defaultAccount && data.defaultAccount.status === 'VALID') {
                defaultAccount = data.defaultAccount;
            } else {
                defaultAccount = validAccounts[0];
            }

            this._defaultAccount = defaultAccount;
        },

        parseData: function(data) {
            this.setDefaultAccount(data);
            this._currentUid = this._defaultAccount.uid;
            this._canAddMore = data['can-add-more'];
            this._accountsList = data.accounts;
            this._accountsLength = data.accounts.length;
        },

        hideAuthLink: function() {
            $('.js-passport-header-authlink-button')
                .parent()
                .remove();
        },

        showDefaultAccount: function(data) {
            if (!data.displayName) {
                return;
            }

            this.$('.js-passport-header-user_name_first-letter').text(data.displayName.charAt(0));
            this.$('.js-passport-header-user_name_allbutfirstletter').text(data.displayName.substr(1));

            var iconUrl = this._avatarHeader.replace('%avatarId%', data.avatarId).replace('%login%', data.login);

            this.$('.js-passport-header-user_icon').css('background-image', ['url(', iconUrl, ')'].join(''));
            this.$('.passport-header-user_display').addClass('js-passport-header-user_dropdown_trigger');
        },

        showMail: function(unread) {
            this.$('.js-passport-header-mail-count').text(unread);
        },

        setPaths: function() {
            this._accounts = this.options.paths.accounts.replace('%tld%', this.options.tld || 'ru');
            this._avatarHeader =
                this.options.paths.avatarHeader + '?rnd=' + String(Math.round(Math.random() * 1000000));
            this._avatarDropdown =
                this.options.paths.avatarDropdown + '?rnd=' + String(Math.round(Math.random() * 1000000));

            if (window.devicePixelRatio > 1) {
                var self = this;

                ['_avatarHeader', '_avatarDropdown'].forEach(function(item) {
                    self[item] = self[item].replace('islands-', 'islands-retina-');
                });
            }

            this.$('.js-passport-header-embeddedauth-form-yu').val(passport.util.getCookie('yandexuid'));

            var retpath = location.href;
            var uidRe = /uid(%3D|=)\d+/g; //TODO: this is scary...

            if (uidRe.test(retpath)) {
                retpath = retpath.replace(uidRe, '');
            }

            this.$('.js-passport-header-embeddedauth-form-retpath').val(retpath);
            this.$('.js-passport-header-embeddedauth-form').attr(
                'action',
                this.options.paths.embeddedauth.replace('%tld%', this.options.tld || 'ru')
            );

            this.$('.js-passport-header-add-user a, .js-passport-header-dropdown-menu__promo a').each(function() {
                this.href = this.href.replace('%retpath%', encodeURIComponent(retpath));
            });

            var logout = this.$('.js-passport-header-link_logout');

            logout.attr('href', logout.attr('href').replace('%yu%', passport.util.getCookie('yandexuid')));
        },

        bindEvents: function() {
            $(document).on('click', this.hideDropdown.bind(this));
        },

        showUserInformation: function() {
            this.showDefaultAccount(this._defaultAccount);

            if (this._accountsList.length == 1 && !passport.util.getCookie('yamultipromo')) {
                this.showPromo();
            } else {
                this.showAccounts(this._accountsList, this._canAddMore);
            }

            if (this._defaultAccount.unread) {
                this.showMail(this._defaultAccount.unread);
            }

            $('.js-passport-header-user_display').removeClass('passport-header-hidden');
        },

        hideUserInformation: function() {
            $('.js-passport-header-user_display')
                .parent()
                .remove();
        },

        showPromo: function() {
            this.$('.js-passport-header-dropdown-menu__promo').removeClass('passport-header-hidden');
        },

        hidePromo: function() {
            var date = new Date();

            date.setDate(date.getDate() + 365);

            document.cookie = 'yamultipromo=' + parseInt(Math.random() * 100000, 10) + ';expires=' + date.toUTCString();
            this.removePromo();
        },

        removePromo: function() {
            this.$('.js-passport-header-dropdown-menu__promo').remove();
            this.$('.js-passport-header-add-user, .js-passport-header-accounts').removeClass('passport-header-hidden');
        },

        showAccounts: function(accounts, canAddMore) {
            var self = this;
            var list = '';
            var addMore = this.$('.js-passport-header-add-user');

            if (accounts.length > 1) {
                $.each(accounts, function() {
                    var user = self
                        .userDraft()
                        .replace(/%uid%/g, this.uid)
                        .replace('%avatarId%', this.avatarId)
                        .replace('%login%', this.login)
                        .replace('%first%', (this.mail || this.login || this.name || '').charAt(0));

                    if (this.status == 'DELETED') {
                        user = user
                            .replace('%class%', 'passport-header-dropdown-menu_user__deleted')
                            .replace('%mail%', this.deleted || '')
                            .replace('%js-class%', '');
                    } else {
                        user = user
                            .replace('%mail%', (this.mail || this.login || this.name).substr(1))
                            .replace('%js-class%', 'js-passport-header-dropdown-user');
                    }

                    list += user;
                });

                addMore.before(list);
            }

            if (canAddMore) {
                addMore.removeClass('passport-header-hidden');
            } else {
                addMore.remove();
            }

            this.$('.js-passport-header-accounts').removeClass('passport-header-hidden');
            this.$('.js-passport-header-dropdown-menu__promo').remove();
        },

        testElem: function(event) {
            return (
                /passport-header-user/.test(event.target.className) ||
                $(event.target)
                    .parents()
                    .hasClass('passport-header-user')
            );
        },

        toggleDropdown: function(event) {
            event.preventDefault();
            this.$('.js-passport-header-user_dropdown').toggleClass('passport-header-menu_open');
        },

        hideDropdown: function(event) {
            if (!this.testElem(event)) {
                this.$('.js-passport-header-user_dropdown').removeClass('passport-header-menu_open');
            }
        },

        changeDefault: function(event) {
            event.preventDefault();

            var uid = $(event.currentTarget).data('uid');

            if (uid && uid != this._currentUid) {
                this.$('.js-passport-header-embeddedauth-form-uid').val(uid);
                this.$('.js-passport-header-embeddedauth-form').submit();
            }
        },

        userDraft: function() {
            /* eslint-disable max-len */
            return (
                '<li class="passport-header-dropdown-menu_user__item %js-class%" data-uid="%uid%"><a class="passport-header-dropdown-menu_item passport-header-dropdown-menu_item__with_icon passport-header-dropdown-menu_user %class%"><span class="passport-header-dropdown-menu_user__avatar" style="background-image:url(' +
                this._avatarDropdown +
                ')"></span><span class="passport-header-dropdown-menu_user__item_mail__first">%first%</span>%mail%</a></li>'
            );
            /* eslint-enable max-len */
        },

        init: function(options) {
            this.options = options;
            this.setPaths();
            this.getData();
            this.bindEvents();
        }
    });
})();
