#!/bin/sh

mkdir -p ./loc

HOST="tanker-api.tools.yandex.net:3000"
HOST="tanker-api.yandex-team.ru"
FORMATS="json"
PROJECT="passport"
LANGS="ru en uk tr fr fi id kk uz az he ky pt"
KEYSETS="Frontend common Header"
BRANCH="locdoc-passport_whitelist"

for LNG in ${LANGS}
do
    for FORMAT in ${FORMATS}
    do
        for KEYSET in ${KEYSETS}
        do
            wget -6 --no-check-certificate -O "./loc/$KEYSET.$LNG.$FORMAT" "https://$HOST/keysets/$FORMAT/?project-id=$PROJECT&branch-id=$BRANCH&keyset-id=$KEYSET&language=$LNG&safe&flat-keyset=1"
        done
    done
done

MULTIAUTH_PROJECT="multiauth"
MULTIAUTH_KEYSETS="dropdown"

for LNG in ${LANGS}
do
    for FORMAT in ${FORMATS}
    do
        for KEYSET in ${MULTIAUTH_KEYSETS}
        do
            wget -6 --no-check-certificate -O "./loc/$KEYSET.$LNG.$FORMAT" "https://$HOST/keysets/$FORMAT/?project-id=$MULTIAUTH_PROJECT&keyset-id=$KEYSET&language=$LNG&safe&flat-keyset=1"
        done
    done
done
