var Configurator;
var Entry;

var assert = require('assert');

/**
 * Class to transform an Entry into a log string
 */
module.exports = require('inherit')({
    /**
     * @param {Configurator} configuration
     * @constructor
     * @class AbstractFormatter
     */
    __constructor: function(configuration) {
        Configurator = Configurator || require('../Configurator');
        assert(configuration instanceof Configurator, 'Configuration should be an instance of Configurator');
        this._config = configuration;
    },

    _format: function() {
        throw new Error('should be overwritten by a successor');
    },

    /**
     * Format the log entry
     * @param {LogEntry} entry
     * @return {string}
     */
    format: function(entry) {
        /* jshint unused:false */

        Entry = Entry || require('../Entry');
        assert(entry instanceof Entry, 'Entry should be a LogEntry');
        return this._format.apply(this, arguments);
    }
});
