var _ = require('lodash');
var util = require('util');
var newlineRe = /\n/g;

module.exports = require('inherit')(require('./AbstractFormatter'), {
    __constructor: function() {
        this.__base.apply(this, arguments);

        this.maxLevelLength = _.max(this._config.getKnownLevels(), function(str) {
            return str.length;
        }).length;
    },

    _format: function(entry) {
        var ts = new Date(entry.getTimestamp());
        //Message converted into a single line
        var message = entry.getMessage().replace(newlineRe, ' -- ');
        var messageLength = message.length;
        const MAX_MESSAGE_LENTGH = 1000;

        if (messageLength > MAX_MESSAGE_LENTGH) {
            message = `${message.slice(0, MAX_MESSAGE_LENTGH)} ...(${messageLength - MAX_MESSAGE_LENTGH} more)`;
        }

        //[[date]] level: message {{tag}} <<logId>>
        return util.format(
            '%s-%s-%s %s:%s:%s.%s %s: %s {{%s}} <<%s>>',

            //TS start
            //Year, month, day, hour, minute, second, millisecond all padded to uniform length
            ts.getFullYear(),
            _.padStart(ts.getMonth() + 1, 2, '0'),
            _.padStart(ts.getDate(), 2, '0'),
            _.padStart(ts.getHours(), 2, '0'),
            _.padStart(ts.getMinutes(), 2, '0'),
            _.padStart(ts.getSeconds(), 2, '0'),
            _.padStart(ts.getMilliseconds(), 3, '0'),
            //TS end

            //Loglevel padded to uniform length across all known levels
            _.padStart(entry.getLevel().toUpperCase(), this.maxLevelLength, ' '),

            message,

            entry.getType().join('.'),
            entry.getLogId()
        );
    }
});
